<?php
#region Fields
if (isset($_SERVER['HTTP_ORIGIN'])) {
    header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
    header('Access-Control-Allow-Credentials: true');
    header('Access-Control-Max-Age: 86400');    // cache for 1 day
}

// Access-Control headers are received during OPTIONS requests
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {

    if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS");         

    if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
        header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");

    exit(0);
}

header('Content-Type: application/json');
date_default_timezone_set('America/Toronto');
set_time_limit(0);
require __DIR__ . '/vendor/autoload.php';
use Firebase\JWT\JWT;
$key     = "EymrGmrVYOqYpKha";


$pdo = new PDO('mysql:host=127.0.0.1;dbname=nextvapk_content_new;charset=utf8mb4','nextvapk_admin','NxTPrO15757475');
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
$pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_OBJ);
$pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
$pdo->setAttribute(PDO::MYSQL_ATTR_INIT_COMMAND, "SET NAMES 'utf8mb4'");

$fluent = new FluentPDO($pdo);

$action = isset($_GET['a']) ? $_GET['a'] : null;
#endregion

#region Functions
switch ($action) {
    case 'login':
        $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
        print_r(json_encode(Login($data)));
        break;
    case 'dash':
        if (isValidToken()) {
            print_r(json_encode(Dashboard()));
        }
        break;
    case 'dash_enable':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_dash_update == 1 ){
                
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(DashEnable($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
            }
            break;
            
    case 'get_user_search':
            if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_admin == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(GetUsersSearch($data)));
                
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
            }
            break;
            
    case 'get_apps_list':
            if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_admin == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(GetAppsList($data)));
                
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
            }
            break;
            
    case 'delete_report':
            if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_admin == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(DeleteReport($data)));
                
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
            }
            break;
    #region Cotent    
    case 'get_search_imdb':
            if (isValidToken($fluent)) {
                
            if($GLOBALS['User']->is_uploader == 1 ){
                print_r(json_encode(SearchContentImdb($_GET['id'], $_GET['type'])));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
            }
            break;
            
    case 'save_content':
           if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(SaveContent($data)));
                
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
           }
           break;

    case 'get_content':
            if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(GetContent($data)));
                
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
            }
            break;

    case 'edit_content':
            if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_uploader == 1 ){
                
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(EditContent($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
            }
            break;
        
    case 'get_content_search':
            if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_uploader == 1 ){
                
                 print_r(json_encode(GetContentList($_GET['type'])));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
            }
            break;

    case 'get_content_media':
            if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_uploader == 1 ){
                
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(GetContentMediaList($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
            }
            break;    
         
    case 'edit_content_media':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(EditContentMedia($data)));
                
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;

    case 'save_content_media':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(SaveContentMedia($data)));
                
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;

    #endregion 
    
    #region Categories
    case 'content':
        if (isValidToken()) {
            if($GLOBALS['User']->is_uploader == 1 ){
                print_r(json_encode(Content()));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;

    case 'save_genere':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_admin == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(SaveGenereContent($data)));
                
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;

    case 'save_genere_special':
        if (isValidToken($fluent)) {
             if($GLOBALS['User']->is_admin == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(SaveGenereContentSpecial($data)));
                
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;

    case 'edit_genere':
        if (isValidToken($fluent)) {
             if($GLOBALS['User']->is_admin == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(EditGenereContent($data)));
                
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;

    case 'edit_genere_special':
        if (isValidToken($fluent)) {
             if($GLOBALS['User']->is_admin == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(EditGenereContentSpecial($data)));
                
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
    #endregion

    #region Users
    case 'create_user':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(CreateUser($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
        
        
    case 'create_demo':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_demo_creator == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(CreateDemo($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
        
        
    case 'get_demos':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_demo_creator == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(GetDemos($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;

    case 'get_users':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(GetUsers($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
        
        case 'get_users_online':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_dealer == 1 ){
                print_r(json_encode(GetOnlineUsers()));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
        
        case 'get_users_historys':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(GetHistoryUsers($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;

    case 'get_user':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(GetUser($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;

    case 'update_user':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(UpdateUser($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;

    case 'remove_sesions':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(RemoveSesion($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
    
    case 'renovate_user':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_dealer == 1 ){
            $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
             print_r(json_encode(RenovateCredit($data)));
                
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
    
    case 'get_devices_user':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_dealer == 1 ){
            $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
             print_r(json_encode(GetUserDevices($data)));
                
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
        
    case 'get_devices_strikes':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_dealer == 1 ){
            $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
             print_r(json_encode(GetUserDevicesStrikes($data)));
                
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
        
    case 'delete_device_user':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                 print_r(json_encode(DeleteDevice($data)));
                
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
    #endregion

    #region Dealers
    case 'get_dealer':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_super_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(GetDealers($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
    case 'get_dealer_by_sp':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_super_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(GetDealersBySP($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
   case 'get_dealer_id':
            if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_super_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(GetDealer($data)));
                
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
            }
            break;
    case 'create_dealer':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_super_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(CreateDealer($data)));
                
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;

    case 'create_super_dealer':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_admin == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(CreateSuperDealer($data)));
                
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;

    case 'edit_dealer':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_super_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(EditDealers($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
        
        case 'fix_dealer_credits':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_super_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(FixDealerCredits($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
        
    case 'disable_all_user_dealer':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_super_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(DisableAllUsers($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
    case 'enable_all_user_dealer':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_super_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(EnableAllUsers($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
    #endregion

    #region Channels

    case 'get_channels':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(getChannels()));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    case 'get_channel':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(getChannel($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    case 'save_channel':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(saveChannel($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    case 'edit_channel':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(editChannel($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    case 'get_categories_channel':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(getCategoryChannel()));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    case 'save_categories_channel':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(addCategoryChannel($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    case 'edit_categories_channel':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(editCategoryChannel($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    case 'channel_update_guide':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(UpdateGuide($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;

    #endregion

    #region Radios

    case 'get_radios':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_admin == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(getRadios()));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    case 'get_radio':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_admin == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(getRadio($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    case 'save_radio':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_admin == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(saveRadios($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    case 'edit_radio':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_admin == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(editRadios($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    #endregion

    #region Adults

    case 'get_adults':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(getAdults()));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    case 'get_adult':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(getAdult($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    case 'save_adult':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(saveAdults($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    case 'edit_adult':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(editAdults($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    #endregion

    #region CustomChannels
    case 'get_custom_channels_info':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_custom_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(getInfoApp($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;

    case 'edit_custom_channels_info':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_custom_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(editInfoApp($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    case 'get_custom_channels_list':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_custom_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(getListChannels($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;

    case 'get_custom_channels':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_custom_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(getChannelsCustom($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;

    case 'get_custom_channel':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_custom_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(getChannelCustom($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;

    case 'save_custom_channels':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_custom_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(saveChannelCustom($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;

    case 'edit_custom_channels':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_custom_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(editChannelCustom($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    case 'disable_custom_channels':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_custom_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(disableChannelCustom($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    case 'delete_custom_channels':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_custom_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(deleteChannelCustom($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;

    case 'get_custom_channels_categories':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_custom_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(getCategoryChannelCustom($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;

    case 'add_custom_channels_categories':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_custom_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(addCategoryChannelCustom($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;

    case 'edit_custom_channels_categories':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_channel_custom_uploader == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(editCategoryChannelCustom($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    #endregion

    #region Bakcrounds

    case 'save_backgrounds':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_background_edit == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(SaveBacground($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;

    case 'delete_background':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_background_edit == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(DeleteBackground($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;

    case 'get_backgrounds':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_background_edit == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(GetBackgrounds($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    
    case 'edit_backgrounds':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_background_edit == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(EditBackground($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
    break;
    #endRegion

    #region UsersXtreamUI
    case 'addUserXtreamUI':
        $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
        print_r(json_encode(addUserXtreamUI($data)));
    break;
    
    case 'deleteUserXtreamUI':
        $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
        print_r(json_encode(DeleteUserXtreamUI($data)));
    break;
    
    case 'updateUserXtreamUI':
        $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
        print_r(json_encode(UpdateUserXtreamUI($data)));
    break;
    
    case 'repairUserXtreamUI':
        $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
        print_r(json_encode(repairUserXtreamUI($data)));
    break;
    #endregion
    
    
    #region Reports
    case 'get_reports':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(getReports($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
        
    case 'get_reports_content':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(getReportsContent($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
        
    case 'get_reports_dealers':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(getReportsDealer($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
        
    case 'get_reports_dealer_users':
        if (isValidToken($fluent)) {
            if($GLOBALS['User']->is_dealer == 1 ){
                $data = json_decode(file_get_contents("php://input"), true, 512, JSON_UNESCAPED_UNICODE);
                print_r(json_encode(getDealerUsers($data)));
            }
            else
            {
                header('Content-Type: application/json');
                print_r(json_encode(array(
                    "code" => 900,
                    "response" => "Expire"
                )));
            }
        }
        break;
    #endregion
}
#endregion

//$GLOBALS['fluent']

#region Lists
function GetAppsList($data)
{
     $Content = $GLOBALS['fluent']
        ->from('app_version')
        ->select(null)
        ->select(array("name"))
        ->where("app_version = ?", "1.2")
        ->fetchAll();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function GetUsersSearch($data)
{
    $Content = $GLOBALS['fluent']
        ->from('users')
        ->select(null)
                ->select(array('id','user', 'expira','created_date', 'registry_id', 'sessions_allowed', 'registry', 'manager', 'created_date', '(SELECT COUNT(*) FROM devices
                WHERE iduser = users.ID AND status = 1) AS deviceCount'))
        ->where("user", $data["user"])
        ->where('type', 1)
        ->fetchAll();

    if(sizeof($Content) > 0)
    {
        return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
    }else
    {
        return array(
            "code" => 2,
            "response" => "Error",
            "Message" => "Usuario no encontrado"
        );
    }
    
}

function DeleteReport($data)
{
    $query = $GLOBALS['fluent']->deleteFrom('reports')->where('id', $data["id"])->execute();
    
    return array(
            "code" => 0,
            "response" => "Succes"
        );
}
#endregion

#region Reports
function getReports()
{
    $Content = $GLOBALS['fluent']
        ->from('admin_history')
        ->where("admin_name", $GLOBALS['User']->username)
        ->orderBy('id ASC')
        ->fetchAll();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function getReportsContent()
{
    $params = [':name' => $GLOBALS['User']->username];
    
    if($GLOBALS['User']->is_admin == 1 ){
        $Content = $GLOBALS['fluent']
        ->from('reports')
        ->orderBy('id DESC')
        ->fetchAll();
    }else{
        $Content = $GLOBALS['fluent']
        ->from('reports')
        ->where('(dealer_name = ? OR spdealer_name = ?)', $GLOBALS['User']->username, $GLOBALS['User']->username)
        ->orderBy('id DESC')
        ->fetchAll();
        
        $set = array("read_report" => 1);
        $query = $GLOBALS['fluent']->update('reports')
        ->set($set)
        ->where('(dealer_name = ? OR spdealer_name = ?)', $GLOBALS['User']->username, $GLOBALS['User']->username)
        ->execute();
        
    }
    

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function getReportsDealer($data)
{
   
       $Content = $GLOBALS['fluent']
       ->from('admin_history')
        ->select(null)
        ->select(array('id', "admin_id", "admin_name", "action", "user_id", "user_name", "credits_old", "credits_new", "date"))
        ->where("admin_name", $data["dealer"])
        ->orderBy('id ASC')
        ->fetchAll(); 
    

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function getDealerUsers($data)
{
    $Content = $GLOBALS['fluent']
        ->from('users')
        ->select(null)
                ->select(array('id','user', 'expira','created_date', 'registry_id', 'registry', 'manager', 'sessions_allowed', 'created_date', '(SELECT COUNT(*) FROM devices
                WHERE iduser = users.ID AND status = 1) AS deviceCount'))
        ->where("registry_id", $data["id"])
        ->where('status', 1)
        ->fetchAll();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}
#endregion

#region Radios
function getRadios()
{
    $Content = $GLOBALS['fluent']
        ->from('radio')
        ->where("activo >= ?", 1)
        ->fetchAll();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function getRadio($data)
{
    $Content = $GLOBALS['fluent']
        ->from('radio')
        ->where("id", $data['id'])
        ->where("status >= ?", 1)
        ->fetch();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function saveRadios($data)
{
    $data["Content"]['user'] = $GLOBALS['User']->username;
     $data["Content"]['fecha_registro'] = "";
    
    $query = $GLOBALS['fluent']->insertInto('radio', $data["Content"])->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function editRadios($data)
{
    $query = $GLOBALS['fluent']->update('radio')->set($data["Content"])->where('id', $data["Content"]['id'])->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}
#endregion

#region Adults
function getAdults()
{
    $Content = $GLOBALS['fluent']
        ->from('linksx')
        ->where("status >= ?", 1)
        ->fetchAll();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function getAdult($data)
{
    $Content = $GLOBALS['fluent']
        ->from('linksx')
        ->where("id", $data['id'])
        ->where("status", 1)
        ->fetch();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function saveAdults($data)
{
    $data["Content"]['usuario'] = $GLOBALS['User']->username;
    
    $query = $GLOBALS['fluent']->insertInto('linksx', $data["Content"])->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function editAdults($data)
{
    $query = $GLOBALS['fluent']->update('linksx')->set($data["Content"])->where('id', $data["Content"]['id'])->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}
#endregion

#region CustomChannels
function getInfoApp($data)
{
    $Content = $GLOBALS['fluent']
        ->from('app_version')
        ->where("name", $GLOBALS['User']->app_allowed)
        ->fetchAll();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content[0]->custom_channels
        );
}

function editInfoApp($data)
{
    $data_save = array("custom_channels" => $data["custom_channels"]);
    $query = $GLOBALS['fluent']->update('app_version')->set($data)->where('name', $GLOBALS['User']->app_allowed)->execute();

    return array(
            "code" => 0,
            "response" => "Succes"
        );
}

function getListChannels($data)
{
    $Content = $GLOBALS['fluent']
        ->from('canales')
        ->select(null)
        ->select(array('id','nombre'))
        ->where("status", 1)
        ->fetchAll();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function getChannelsCustom($data)
{
    $Content = $GLOBALS['fluent']
        ->from('canales_custom')
        ->select(null)
        ->select(array('id','numero', 'nombre','categoria','activo'))
        ->where("user", $GLOBALS['User']->username)
        ->where("app_allowed", $GLOBALS['User']->app_allowed)
        ->where("status", 1)
        ->fetchAll();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function getChannelCustom($data)
{
    $Content = $GLOBALS['fluent']
        ->from('canales_custom')
        ->where("id", $data['id'])
        ->where("status", 1)
        ->where("user", $GLOBALS['User']->username)
        ->fetch();
    
    if($Content->type == 2)
    {
        $Content->link = "";
        $Content->id_channel = "";
    }

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function saveChannelCustom($data)
{

    $today = date('Y-m-d H:i:s');
    $data['user'] = $GLOBALS['User']->username;
    $data['app_allowed'] = $GLOBALS['User']->app_allowed;
    $data['fecha_registro'] = $today;
    
    if($data["type"] == 2)
    {
        $Content = $GLOBALS['fluent']
                    ->from('canales')
                    ->where("id", $data['id_channel'])
                    ->fetch();
        $data['link'] = $Content->link;
    }else
    {
        $data['id_channel'] = 0;
    }
    
    $query = $GLOBALS['fluent']->insertInto('canales_custom', $data)->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function editChannelCustom($data)
{
    if($data["type"] == 1)
    {
        $data_guardar = array(
        "nombre" => $data["nombre"],
        "link" => $data["link"],
        "logo" => $data["logo"],
        "id_guia" => $data["id_guia"],
        "categoria" => $data["categoria"],
        "numero" => $data["numero"] 
    );
    }else
    {
        $data_guardar = array(
        "nombre" => $data["nombre"],
        "logo" => $data["logo"],
        "id_guia" => $data["id_guia"],
        "categoria" => $data["categoria"],
        "numero" => $data["numero"] 
    );
    }
    

    $query = $GLOBALS['fluent']->update('canales_custom')->set($data_guardar)->where('id', $data['id'])->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function disableChannelCustom($data){
    $data_guardar = array(
        "activo" => $data["activo"]
    );
    
    $query = $GLOBALS['fluent']->update('canales_custom')->set($data_guardar)->where('id', $data['id'])->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function deleteChannelCustom($data){
    $data_guardar = array(
        "status" => $data["status"]
    );
    
    $query = $GLOBALS['fluent']->update('canales_custom')->set($data_guardar)->where('id', $data['id'])->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function getCategoryChannelCustom($data)
{
    $Content = $GLOBALS['fluent']
        ->from('canales_categorias_custom')
        ->where("app_allowed", $GLOBALS['User']->app_allowed)
        ->fetchAll();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function addCategoryChannelCustom($data)
{
    $data['user'] = $GLOBALS['User']->username;
    $data['app_allowed'] = $GLOBALS['User']->app_allowed;

    $query = $GLOBALS['fluent']->insertInto('canales_categorias_custom', $data)->execute();

    return array(
        "code" => 0,
        "response" => "Succes",
        "data" => $data
    );
}

function editCategoryChannelCustom($data)
{
    $query = $GLOBALS['fluent']->update('canales_categorias_custom')->set($data)->where('id', $data['id'])->where("app_allowed", $GLOBALS['User']->app_allowed)->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function UpdateGuide($data)
{
    $url = 'http://guide.xbrtv39.com/create_guide_new.php';
    $content = file_get_contents($url);
    $json_es = json_decode($content, true);
    
    $today = date("F j, Y, g:i:s a");
    $set = array(
        'fecha' => $today
    );
    
    $query = $GLOBALS['fluent']->update('update_items')->set($set)->where('categoria', 'guide')->execute();
    
    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

#endregion

#region UsersXtreamUI

function repairUserXtreamUI($data)
{
    $query = $GLOBALS['fluent7']->from('users')->where('username', $data["user"])->where('password', $data["pass"])->fetchAll();
    
    if(sizeof($query) > 0)
    {
        UpdateUserXtreamUI($data);
    }else
    {
        addUserXtreamUI($data);
    }
}

function addUserXtreamUI($data)
{
 
    $query = $GLOBALS['fluent7']->from('users')->where('username', $data["user"])->fetchAll();
    if(sizeof($query) > 0)
    {
        
    }
    else{
        $values_1 = array(
            'member_id' => 1, 
            'username' => $data["user"],
            'password' => $data["pass"], 
            'exp_date' => $data["date"],
            'admin_enabled' => 1, 
            'enabled' => 1,
            'admin_notes' => '', 
            'reseller_notes' => '',
            'bouquet' => '["8"]', 
            'max_connections' =>$data["connection"],
            'is_restreamer' => 0, 
            'allowed_ips' => '[]',
            'allowed_ua' => '[]', 
            'is_trial' => 0,
            'created_at' => 1584944180, 
            'created_by' => 1,
            'is_mag' => 0,
            'is_e2' => 0, 
            'force_server_id' => 0,
            'is_isplock' => 0, 
            'isp_desc' => '', 
            'forced_country' => '',
            'is_stalker' => 0, 
            'bypass_ua' => 0,
            'play_token' => ''
        );
        
        $values_2 = array(
            'member_id' => 1, 
            'username' => $data["user"],
            'password' => $data["pass"], 
            'exp_date' => $data["date"],
            'admin_enabled' => 1, 
            'enabled' => 1,
            'admin_notes' => '', 
            'reseller_notes' => '',
            'bouquet' => '["5"]', 
            'max_connections' =>$data["connection"],
            'is_restreamer' => 0, 
            'allowed_ips' => '[]',
            'allowed_ua' => '[]', 
            'is_trial' => 0,
            'created_at' => 1584944180, 
            'created_by' => 1,
            'is_mag' => 0,
            'is_e2' => 0, 
            'force_server_id' => 0,
            'is_isplock' => 0, 
            'isp_desc' => '', 
            'forced_country' => '',
            'is_stalker' => 0, 
            'bypass_ua' => 0,
            'play_token' => ''
        );
        
        $query = $GLOBALS['fluent7']->insertInto('users')->values($values_1)->execute();
        $query_2 = $GLOBALS['fluent8']->insertInto('users')->values($values_2)->execute();
        
        $values_one = array(
            'user_id' => $query,
            'access_output_id' => 1
        );
        
        $values_two = array(
            'user_id' => $query,
            'access_output_id' => 2
        );
        
        $values_three = array(
            'user_id' => $query,
            'access_output_id' => 3
        );
        
        $query_one = $GLOBALS['fluent7']->insertInto('user_output')->values($values_one)->execute();
        $query_two = $GLOBALS['fluent7']->insertInto('user_output')->values($values_two)->execute();
        $query_three = $GLOBALS['fluent7']->insertInto('user_output')->values($values_three)->execute();
        
        
        $values_one = array(
            'user_id' => $query_2,
            'access_output_id' => 1
        );
        
        $values_two = array(
            'user_id' => $query_2,
            'access_output_id' => 2
        );
        
        $values_three = array(
            'user_id' => $query_2,
            'access_output_id' => 3
        );
        
        $query_one = $GLOBALS['fluent8']->insertInto('user_output')->values($values_one)->execute();
        $query_two = $GLOBALS['fluent8']->insertInto('user_output')->values($values_two)->execute();
        $query_three = $GLOBALS['fluent8']->insertInto('user_output')->values($values_three)->execute();

    }
    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $query
        );
}

function DeleteUserXtreamUI($data)
{
    $query = $GLOBALS['fluent7']->from('users')->where('username', $data["user"])->where('password', $data["pass"])->fetchAll();
    $query_2 = $GLOBALS['fluent8']->from('users')->where('username', $data["user"])->where('password', $data["pass"])->fetchAll();
    
    if(sizeof($query) > 0){
        $queryd = $GLOBALS['fluent7']->deleteFrom('user_output')->where('id', $query[0]->id)->execute();
        $queryd = $GLOBALS['fluent7']->deleteFrom('users')->where('id', $query[0]->id)->execute();
    }
    
    if(sizeof($query_2) > 0){
        $queryd = $GLOBALS['fluent8']->deleteFrom('user_output')->where('id', $query_2[0]->id)->execute();
        $queryd = $GLOBALS['fluent8']->deleteFrom('users')->where('id', $query_2[0]->id)->execute();
    }
    
    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $data
        );
}

function UpdateUserXtreamUI($data)
{
    $query = $GLOBALS['fluent7']->from('users')->where('username', $data["userOld"])->where('password', $data["passwordOld"])->fetchAll();
    $query_2 = $GLOBALS['fluent8']->from('users')->where('username', $data["userOld"])->where('password', $data["passwordOld"])->fetchAll();
    
    $values_1 = array(
        'username' => $data["user"],
        'password' => $data["pass"], 
        'exp_date' => $data["date"],
        'max_connections' =>$data["connection"]
    );
    
    if(sizeof($query) > 0){
        $queryd = $GLOBALS['fluent7']->update('users')->set($values_1)->where('id', $query[0]->id)->execute();
    }
    
    if(sizeof($query_2) > 0){
        $queryd = $GLOBALS['fluent8']->update('users')->set($values_1)->where('id', $query_2[0]->id)->execute();
    }
    
    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => sizeof($query),
            "Content2" => sizeof($query_2),
            "Data" => $data
        );
    
}
#endregion

#region Channels
function getChannels()
{
    $Content = $GLOBALS['fluent']
        ->from('canales')
        ->select(null)
        ->select(array('id','numero', 'nombre','categoria','activo'))
        ->where("user", $GLOBALS['User']->username)
        ->where("status", 1)
        ->fetchAll();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function getChannel($data)
{
    $Content = $GLOBALS['fluent']
        ->from('canales')
        ->where("id", $data['id'])
        ->where("status", 1)
        ->where("user", $GLOBALS['User']->username)
        ->fetch();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function saveChannel($data)
{
    $today = date('Y-m-d H:i:s');
    $data['user'] = $GLOBALS['User']->username;
    $data['fecha_registro'] = $today;
    
    $query = $GLOBALS['fluent']->insertInto('canales', $data)->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function editChannel($data)
{
    $query = $GLOBALS['fluent']->update('canales')->set($data)->where('id', $data['id'])->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function getCategoryChannel()
{
    $Content = $GLOBALS['fluent']
        ->from('canales_categorias')
        ->fetchAll();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function addCategoryChannel($data)
{
    $query = $GLOBALS['fluent']->insertInto('canales_categorias', $data)->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function editCategoryChannel($data)
{
    $query = $GLOBALS['fluent']->update('canales_categorias')->set($data)->where('id', $data['id'])->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

#endregion

#region Dealers & Super Dealers

function GetDealers($data){

    if($data['type'] == 1)
    {
        $Content = $GLOBALS['fluent']
        ->from('administrators')
        ->where('status', 1)
        ->where('is_dealer', true)
        ->where('is_super_dealer', false)
        ->fetchAll();
    }
    else{
        $Content = $GLOBALS['fluent']
        ->from('administrators')
        ->where('status', 1)
        ->where('is_dealer', true)
        ->where('is_super_dealer', true)
        ->fetchAll();
    }
    

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function GetDealersBySP($data){

  
   $Content = $GLOBALS['fluent']
       ->from('administrators')
       ->where('status', 1)
       ->where('created_at', $data["spDealer"])
       ->where('is_dealer', true)
       ->where('is_super_dealer', false)
       ->fetchAll();
    
    
    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function GetDealer($data){

    $Content = $GLOBALS['fluent']
        ->from('administrators')
        ->where('status', 1)
        ->where('id', $data['id'])
        ->fetch();
    

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function CreateDealer($data)
{
    $user_data = $data;
    //$user_type= $data["Type"];
    $today = date('Y-m-d H:i:s');
    
    $resultCredits = $GLOBALS['User']->credits_allowed - $GLOBALS['User']->credits;
    
    if( $resultCredits < $user_data['credits_allowed']){
        return array(
            "code" => 2,
            "response" => "Error",
            "Message" => "Ya no cuentas con creditos"
        );
    }

    $oldCredits = $GLOBALS['User']->credits;
    
    $appName = $GLOBALS['User']->app_allowed;
    
    if($user_data['app_allowed'] != "null")
    {
        if($GLOBALS['User']->is_admin == 1)
        {
             $appName = $user_data['app_allowed'];
        }
    }

    $values = array(
        'username' => $user_data['username'], 
        'passcode' => $user_data['passcode'], 
        'credits_allowed' => $user_data['credits_allowed'], 
        'credits' => 0, 
        'avatar' => '/images/avatar.png',
        'is_admin' => 0,
        'is_dealer' => 1,
        'is_super_dealer' => 0,
        'is_uploader' => 0,
        'is_channel_uploader' => 0,
        'is_background_edit' => $user_data['is_background_edit'],
        'is_channel_custom_uploader' => $user_data['is_channel_custom_uploader'],
        'is_dash_update' => $user_data['is_dash_update'],
        'is_demo_creator' => $user_data['is_demo_creator'],
        'created_at' => $GLOBALS['User']->username, 
        'creat_at_id' => $GLOBALS['User']->id, 
        'status' => 1, 
        'app_id' => $GLOBALS['User']->app_id,
        'app_allowed' =>$appName
    );

    $queryUser = $GLOBALS['fluent']->insertInto('administrators')->values($values)->execute();

    $result = $GLOBALS['User']->credits + $user_data['credits_allowed'];
    $set = array('credits' => $result);
    $query = $GLOBALS['fluent']->update('administrators')->set($set)->where("username", $GLOBALS['User']->username)->execute();

    $valuesHistory = array(
        'admin_id' => $GLOBALS['User']->id, 
        'admin_name' => $GLOBALS['User']->username, 
        'action' => 'Creo Dealer', 
        'user_id' => $queryUser, 
        'user_name' => $user_data['username'], 
        'credits_old' => $oldCredits, 
        'credits_new' => $result ,
        'date' => $today,
        'old' => '',
        'new' => json_encode($values)
    );

    $query = $GLOBALS['fluent']->insertInto('admin_history', $valuesHistory)->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function CreateSuperDealer($data)
{
    $user_data = $data;
    //$user_type= $data["Type"];
    $today = date('Y-m-d H:i:s');
    $resultCredits = $GLOBALS['User']->credits_allowed - $GLOBALS['User']->credits;
    if( $resultCredits > 0 && $resultCredits < $user_data['credits_allowed']){
        return array(
            "code" => 2,
            "response" => "Error",
            "Message" => "Ya no cuentas con creditos"
        );
    }

    $oldCredits = $GLOBALS['User']->credits;
    
    $appName = $GLOBALS['User']->app_allowed;
    
    if($user_data['app_allowed'] != "null")
    {
        if($GLOBALS['User']->is_admin == 1)
        {
             $appName = $user_data['app_allowed'];
        }
    }
    

    $values = array(
        'username' => $user_data['username'], 
        'passcode' => $user_data['passcode'], 
        'credits_allowed' => $user_data['credits_allowed'], 
        'credits' => 0, 
        'avatar' => '/images/avatar.png',
        'is_admin' => 0,
        'is_dealer' => 1,
        'is_super_dealer' => 1,
        'is_uploader' => 0,
        'is_channel_uploader' => 0,
        'is_background_edit' => $user_data['is_background_edit'],
        'is_channel_custom_uploader' => $user_data['is_channel_custom_uploader'],
        'is_dash_update' => $user_data['is_dash_update'],
        'is_demo_creator' => $user_data['is_demo_creator'],
        'created_at' => $GLOBALS['User']->username, 
        'creat_at_id' => $GLOBALS['User']->id, 
        'status' => 1, 
        'app_id' => $GLOBALS['User']->app_id,
        'app_allowed' => $appName
    );

    $queryUser = $GLOBALS['fluent']->insertInto('administrators')->values($values)->execute();

    $result = $GLOBALS['User']->credits + $user_data['credits_allowed'];
    $set = array('credits' => $result);
    $query = $GLOBALS['fluent']->update('administrators')->set($set)->where("username", $GLOBALS['User']->username)->execute();

    $valuesHistory = array(
        'admin_id' => $GLOBALS['User']->id, 
        'admin_name' => $GLOBALS['User']->username, 
        'action' => 'Creo Dealer', 
        'user_id' => $queryUser, 
        'user_name' => $user_data['username'], 
        'credits_old' => $oldCredits, 
        'credits_new' => $result ,
        'date' => $today,
        'old' => '',
        'new' => json_encode($values)
    );

    $query = $GLOBALS['fluent']->insertInto('admin_history', $valuesHistory)->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function EditDealers($data)
{
    try{
        
        $creditsUse = $data["Credits"];
        
        if($creditsUse < 0)
        {
             return array(
                "code" => 2,
                "response" => "Error",
                "Message" => "Creditos Mayor o igual a 0"
            );
        }
        
        $today = date('Y-m-d H:i:s');
        $creditsRest = $GLOBALS['User']->credits_allowed - $GLOBALS['User']->credits;
        $user_data = $data["User"];
        $user_type= $data["Type"];
        
        

        if($creditsRest < $creditsUse){
            return array(
                "code" => 2,
                "response" => "Error",
                "Message" => "Ya no cuentas con creditos"
            );
        }
        
        $oldCredits = $GLOBALS['User']->credits;
        

        $user =$GLOBALS['fluent']->from('administrators')
        ->where("id",$user_data['id'])
        ->fetch();

        $credits_allowed = $user->credits_allowed + $creditsUse;

        $set_user_old = array(
            'credits_allowed' => $user->credits_allowed,
            'passcode' => $user->passcode,
            'status' => $user->status
        );

        $set_user = array(
            'credits_allowed' => $credits_allowed,
            'passcode' => $user_data['passcode'],
            'status' => $user_data['status'],
            'is_background_edit' => $user_data['is_background_edit'],
            'is_channel_custom_uploader' => $user_data['is_channel_custom_uploader'],
            'is_dash_update' => $user_data['is_dash_update'],
            'is_demo_creator' => $user_data['is_demo_creator'],
        );

        $query_user =$GLOBALS['fluent']->update('administrators')->set($set_user)
                            ->where("id",$user_data['id'])
                            ->execute();

        $result = $GLOBALS['User']->credits + $creditsUse;
        $set = array('credits' => $result);
        $query = $GLOBALS['fluent']->update('administrators')->set($set)->where("username", $GLOBALS['User']->username)->execute();

        $Title = "";
        if($creditsUse > 0)
            $Title = "Renovo Dealer";
        else if($user_data["status"] == 0)
            $Title = "Elimino Dealer";
        else
            $Title = "Edito Dealer";


        $valuesHistory = array(
            'admin_id' => $GLOBALS['User']->id, 
            'admin_name' => $GLOBALS['User']->username, 
            'action' => $Title, 
            'user_id' => $user_data['id'], 
            'user_name' => $user_data['username'], 
            'credits_old' => $oldCredits, 
            'credits_new' => $result ,
            'date' => $today,
            'old' => json_encode($set_user_old),
            'new' => json_encode($set_user)
        );

        $query = $GLOBALS['fluent']->insertInto('admin_history', $valuesHistory)->execute();

        return array(
            "code" => 0,
            "response" => "Succes"
        );
    }catch (PDOException $e) {
        return array(
            "code" => 2,
            "response" => "Error",
            "Message" => $e->getMessage()
        );
    } 
}

function FixDealerCredits($data)
{
    try{
        
        $creditsUse = $data["Credits"];
        
        if($creditsUse < 0)
        {
             return array(
                "code" => 2,
                "response" => "Error",
                "Message" => "Creditos Mayor o igual a 0"
            );
        }
        
        $today = date('Y-m-d H:i:s');
        $oldCredits = $GLOBALS['User']->credits;
        $user_data = $data["User"];
        $user_type= $data["Type"];
        
        $InfoDealer = $GLOBALS['fluent']
            ->from('administrators')
            ->where("creat_at_id", $GLOBALS['User']->id)
            ->where('status', 1)
            ->where('id', $user_data['id'])
            ->fetch();
            
        $creditsRest = $InfoDealer->credits_allowed - $InfoDealer->credits;
        
        if($creditsRest >= $creditsUse)
        {
            
             $set_user_old = array(
                'credits_allowed' => $InfoDealer->credits_allowed
            );
        
            $setDealer = array( "credits_allowed" => ($InfoDealer->credits_allowed - $creditsUse));
            $setMy = array( "credits" => ($GLOBALS['User']->credits - $creditsUse));
            
            $query_user =$GLOBALS['fluent']->update('administrators')->set($setMy)
                            ->where("username", $GLOBALS['User']->username)
                            ->execute();
                            
                            
            $query_user =$GLOBALS['fluent']->update('administrators')->set($setDealer)
                            ->where("id",$InfoDealer->id)
                            ->execute();
                            
            $valuesHistory = array(
                'admin_id' => $GLOBALS['User']->id, 
                'admin_name' => $GLOBALS['User']->username, 
                'action' => "Resto Creditos Dealer", 
                'user_id' => $InfoDealer->id, 
                'user_name' => $InfoDealer->username, 
                'credits_old' => $oldCredits, 
                'credits_new' => ($GLOBALS['User']->credits - $creditsUse) ,
                'date' => $today,
                'old' => json_encode($set_user_old),
                'new' => json_encode($setDealer)
            );
    
            $query = $GLOBALS['fluent']->insertInto('admin_history', $valuesHistory)->execute();

            return array(
                "Info" => $setMy,
                "code" => 0,
                "response" => "Succes"
            );
        }
        
        return array(
            "Message"=>"El usuario no tiene creditos diponibles para restar la cantidad.",
            "code" => 2,
            "response" => "Error"
        );
        
    }catch (PDOException $e) {
        return array(
            "code" => 2,
            "response" => "Error",
            "Message" => $e->getMessage()
        );
    } 
}

function DisableAllUsers($data)
{
    $set = array('status' => 2);
    $query = $GLOBALS['fluent']->update('users')->set($set)->where('registry_id', $data['id'])->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function EnableAllUsers($data)
{
    $set = array('status' => 1);
    $query = $GLOBALS['fluent']->update('users')->set($set)->where('registry_id', $data['id'])->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

#endregion

#region User
function CreateUser($data)
{
    try{

        $oldCredits = $GLOBALS['User']->credits;
        $user_data = $data["User"];
        $user_type= $data["Type"];

        $creditsRest = $GLOBALS['User']->credits_allowed - $GLOBALS['User']->credits;

        if($user_type == 1){
            $creditsUse = 1;
        }else if($user_type == 2){
            $creditsUse = 3;
        }else if($user_type == 3){
            $creditsUse = 6;
        }else {
            $creditsUse = 12;
        }

        if($creditsRest < $creditsUse){
            return array(
                "code" => 2,
                "response" => "Error",
                "Message" => "Ya no cuentas con creditos, Disponibles: ".$creditsRest,
                "CredistRest" => $creditsRest,
                "CredistRestUse" => $creditsUse
            );
        }
        
        

        $today = date('Y-m-d H:i:s');
        $NewDate = strtotime ( '+1 year' , strtotime ( $today ) ) ;
        $LimiteDate = date ( 'Y-m-d H:i:s' , $NewDate );

        if($user_type == 1){
            $NewDate = strtotime ( '+1 month' , strtotime ( $today ) ) ;
            $Expira = date ( 'Y-m-d H:i:s' , $NewDate );
        }else if($user_type == 2){
            $NewDate = strtotime ( '+3 month' , strtotime ( $today ) ) ;
            $Expira = date ( 'Y-m-d H:i:s' , $NewDate );
        }else if($user_type == 3){
            $NewDate = strtotime ( '+6 month' , strtotime ( $today ) ) ;
            $Expira = date ( 'Y-m-d H:i:s' , $NewDate );
        }else if($user_type == 4){
            $NewDate = strtotime ( '+1 year' , strtotime ( $today ) ) ;
            $Expira = date ( 'Y-m-d H:i:s' , $NewDate );
        }

        $salt = uniqid(mt_rand(), true);
        $Toekn= md5($salt.$user_data['user'].$user_data['password']);

        $values = array(
            'user' => $user_data['name'], 
            'email' => $user_data['email'],
            'password' => $user_data['password'], 
            'description' => $user_data['description'], 
            'token' => $Toekn, 
            'expira' => $Expira, 
            'limit_date' => $Expira, 
            'sessions' => 0, 
            'sessions_allowed' => $user_data['sessions_allowed'], 
            'status' => 1, 
            'registry' => $GLOBALS['User']->username, 
            'registry_id' => $GLOBALS['User']->id, 
            'manager' => $GLOBALS['User']->created_at, 
            'manager_id' => $GLOBALS['User']->creat_at_id, 
            'message' => '', 
            'app_allowed' => $user_data['app_allowed'], 
            'type' => 1, 
        );


        $queryUser = $GLOBALS['fluent']->insertInto('users')->values($values)->execute();
        
        $user = $user_data['name']."_new_app";
        
        $long = strtotime($Expira);
        
        $data = json_encode(array(
                "userOld" => $user, 
                "passwordOld" => $user_data['password'],
                "user" => $user, 
                "pass" => $user_data['password'], 
                "date" => $long, 
                "connection" => 1
                ));
        
        $result_ui = CallAPI("POST", "http://panelapi.nextvapk.com/xtream_ui_connection.php?a=repairUserXtreamUI", $data);

        $result = $GLOBALS['User']->credits + $creditsUse;
        $set = array('credits' => $result);
        $query = $GLOBALS['fluent']->update('administrators')->set($set)->where("username", $GLOBALS['User']->username)->execute();

        unset($values["token"]); 
        unset($values["registry"]); 
        unset($values["registry_id"]); 
        unset($values["manager"]); 
        unset($values["manager_id"]); 
        unset($values["app_allowed"]); 

        $valuesHistory = array(
            'admin_id' => $GLOBALS['User']->id, 
            'admin_name' => $GLOBALS['User']->username, 
            'action' => 'Creo Usuario', 
            'user_id' => $queryUser, 
            'user_name' => $user_data['name'], 
            'credits_old' => $oldCredits, 
            'credits_new' => $result ,
            'date' => $today,
            'old' => '',
            'new' => json_encode($values)
        );

        $query = $GLOBALS['fluent']->insertInto('admin_history', $valuesHistory)->execute();

        return array(
            "code" => 0,
            "response" => "Succes",
            "CredistRest" => $creditsRest,
            "CredistRestUse" => $creditsUse,
            "response_ui" => $result_ui
        );
    }catch (PDOException $e) {
        return array(
            "code" => 2,
            "response" => "Error",
            "Message" => $e->getMessage()
        );
    }    
}

function CreateDemo($data)
{
    
    $Content = $GLOBALS['fluent']
        ->from('count_demo')
        ->orderBy('id DESC')
        ->limit(1)
        ->fetchAll();
    $user_name = "DEMO-".($Content[0]->id+1);
    $salt = uniqid(mt_rand(), true);
    $Toekn= md5($salt.$user_name.$data["Content"]['password']);
    
    
    $today = date('Y-m-d H:i:s');
    $NewDate = strtotime ( '+1 year' , strtotime ( $today ) ) ;
    $LimiteDate = date ( 'Y-m-d H:i:s' , $NewDate );
    
    $NewDate = strtotime ( '+1 day' , strtotime ( $today ) ) ;
    $Expira = date ( 'Y-m-d H:i:s' , $NewDate );
    
    
    $NewDateXtreamUI = strtotime ( '+2 day' , strtotime ( $today ) ) ;
    $ExpiraXtreamUI = date ( 'Y-m-d H:i:s' , $NewDateXtreamUI );
            
    $values = array(
            'user' => $user_name, 
            'email' => "",
            'password' => $data["Content"]['password'], 
            'description' => $data["Content"]['description'], 
            'token' => $Toekn, 
            'expira' => $Expira, 
            'limit_date' => $Expira, 
            'sessions' => 0, 
            'sessions_allowed' => 1, 
            'status' => 1, 
            'registry' => $GLOBALS['User']->username, 
            'registry_id' => $GLOBALS['User']->id, 
            'manager' => $GLOBALS['User']->created_at, 
            'manager_id' => $GLOBALS['User']->creat_at_id, 
            'message' => 'DEMO', 
            'app_allowed' => $GLOBALS['User']->app_allowed, 
            'type' => 2, 
        );
        
    $queryUser = $GLOBALS['fluent']->insertInto('users')->values($values)->execute();
    
    $user = $user_name."_new_app";
        
    $long = strtotime($ExpiraXtreamUI);
    
    $data = json_encode(array(
            "userOld" => $user, 
            "passwordOld" => $data["Content"]['password'],
            "user" => $user, 
            "pass" => $data["Content"]['password'], 
            "date" => $long, 
            "connection" => 1
            ));
    
    $result_ui = CallAPI("POST", "http://panelapi.nextvapk.com/xtream_ui_connection.php?a=repairUserXtreamUI", $data);

    unset($values["token"]); 
    unset($values["registry"]); 
    unset($values["registry_id"]); 
    unset($values["manager"]); 
    unset($values["manager_id"]); 
    unset($values["app_allowed"]); 

    $valuesHistory = array(
        'admin_id' => $GLOBALS['User']->id, 
        'admin_name' => $GLOBALS['User']->username, 
        'action' => 'Creo Demo', 
        'user_id' => $queryUser, 
        'user_name' => $user_name, 
        'credits_old' => $GLOBALS['User']->credits, 
        'credits_new' => $GLOBALS['User']->credits ,
        'date' => $today,
        'old' => '',
        'new' => json_encode($values)
    );

    $query = $GLOBALS['fluent']->insertInto('admin_history', $valuesHistory)->execute();
    
    
    $valuesDemo = array("name" => $user_name);
    $query = $GLOBALS['fluent']->insertInto('count_demo', $valuesDemo)->execute();
    
    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $values
        );
}

function GetDemos($data)
{
    $fecha = date('Y-m-d H:i:s');
    
    $Content = $GLOBALS['fluent']
        ->from('users')
        ->select(null)
                ->select(array('id','user', 'password', 'description', 'expira','created_date', 'registry_id', 'sessions_allowed', 'created_date', '(SELECT COUNT(*) FROM devices
                WHERE iduser = users.ID AND status = 1) AS deviceCount'))
        ->where("registry_id", $GLOBALS['User']->id)
        ->where('status', 1)
        ->where('type', 2)
        ->where('expira >= ?', $fecha)
        ->fetchAll();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function GetUsers($data)
{
    $Content = $GLOBALS['fluent']
        ->from('users')
        ->select(null)
                ->select(array('id','user', 'expira','created_date', 'registry_id', 'sessions_allowed', 'created_date', '(SELECT COUNT(*) FROM devices
                WHERE iduser = users.ID AND status = 1) AS deviceCount'))
        ->where("registry_id", $GLOBALS['User']->id)
        ->where('status', 1)
        ->where('type', 1)
        ->fetchAll();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function GetUser($data)
{
    $Content = $GLOBALS['fluent']
        ->from('users')
        ->where('id', $data['id'])
        ->where('status', 1)
        ->fetch();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function UpdateUser($data)
{
    
    
    if(array_key_exists('email', $data)){
        
        try{
            $set = array(
                'user' => $data['user'], 
                'email' => $data['email'], 
                'message' => $data['message'], 
                'password' => $data['password'], 
                'description' => $data['description'], 
                'special_content' => $data['special_content'], 
                'app_allowed' => $data['app_allowed'],
                'sessions_allowed' => $data['sessions_allowed']);
    
        
           $query = $GLOBALS['fluent']->update('users')->set($set)->where('id', $data['id'])->execute();
            
           $user = $data['user']."_new_app";
                
           $long = strtotime($data["expira"]);
                
            $data = json_encode(array(
                    "userOld" => $data['userOld']."_new_app", 
                    "passwordOld" => $data['password'],
                    "user" => $user, 
                    "pass" => $data['password'], 
                    "date" => $long, 
                    "connection" => 1
                    ));
            
            $result_ui = CallAPI("POST", "http://panelapi.nextvapk.com/xtream_ui_connection.php?a=repairUserXtreamUI", $data);
        
            return array(
                "code" => 0,
                "response" => "Succes",
                "response_ui" => $result_ui
            );
        }catch (PDOException $e) {
        return array(
            "code" => 2,
            "response" => "Error",
            "Message" => $e->getMessage()
        );
    }  
    }
   
    else if(array_key_exists('status', $data)){
       $set = array('status' => $data['status']);
        
       $query = $GLOBALS['fluent']->update('users')->set($set)->where('id', $data['id'])->execute();
    
        return array(
            "code" => 0,
            "response" => "Succes"
        );
    }
    
    
    else if(array_key_exists('content_block', $data)){
       
       if($data['content_block'] == 1)
       {
           $set = array('content_block' => $data['content_block'], 'note_block'  => "Block desde el panel");
       }else
       {
           $set = array('content_block' => $data['content_block'], 'note_block'  => "");
       }
        
       $query = $GLOBALS['fluent']->update('users')->set($set)->where('id', $data['id'])->execute();
    
        return array(
            "code" => 0,
            "response" => "Succes"
        );
    }
    
   return array(
            "code" => 0,
            "response" => "Succes"
        );
}

function RemoveSesion($data)
{
    $set = array('status' => 0);
    $query = $GLOBALS['fluent']->update('devices')->set($set)->where('iduser', $data['id'])->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function RenovateCredit($data)
{
    try{

        $oldCredits = $GLOBALS['User']->credits;
        $user_data = $data["User"];
        $user_type= $data["Type"];

        $creditsRest = $GLOBALS['User']->credits_allowed - $GLOBALS['User']->credits;

        if($user_type == 1){
            $creditsUse = 1;
        }else if($user_type == 2){
            $creditsUse = 3;
        }else if($user_type == 3){
            $creditsUse = 6;
        }else {
            $creditsUse = 12;
        }

        if($creditsRest < $creditsUse){
            return array(
                "code" => 2,
                "response" => "Error",
                "Message" => "Ya no cuentas con creditos"
            );
        }
        
        

        $user =$GLOBALS['fluent']->from('users')
        ->where("id",$user_data['id'])
        ->fetch();

        $today = date('Y-m-d H:i:s');
        $NewDate = strtotime ( '+1 year' , strtotime ( $today ) ) ;
        $LimiteDate = date ( 'Y-m-d H:i:s' , $NewDate );

        $today = date("Y-m-j g:i:s");
        $expiradate = $user->expira;
        
        $dateTimestamp1 = strtotime($today); 
        $dateTimestamp2 = strtotime($expiradate); 

        if ($dateTimestamp2 >= $dateTimestamp1) {
            $date =  $expiradate; 
          }else{
            $date =  $today;
          }

        if($user_type == 1){
            $NewDate = strtotime ( '+1 month' , strtotime ( $date ) ) ;
            $Expira = date ( 'Y-m-d H:i:s' , $NewDate );
        }else if($user_type == 2){
            $NewDate = strtotime ( '+3 month' , strtotime ( $date ) ) ;
            $Expira = date ( 'Y-m-d H:i:s' , $NewDate );
        }else if($user_type == 3){
            $NewDate = strtotime ( '+6 month' , strtotime ( $date ) ) ;
            $Expira = date ( 'Y-m-d H:i:s' , $NewDate );
        }else if($user_type == 4){
            $NewDate = strtotime ( '+1 year' , strtotime ( $date ) ) ;
            $Expira = date ( 'Y-m-d H:i:s' , $NewDate );
        }
        $set_user_old = array('limit_date' => $user->limit_date, 'expira' => $user->expira);
        $set_user = array('limit_date' => $Expira, 'expira' => $Expira);
        
        $query_user =$GLOBALS['fluent']->update('users')->set($set_user)
                            ->where("id",$user_data['id'])
                            ->execute();

        $result = $GLOBALS['User']->credits + $creditsUse;
        $set = array('credits' => $result);
        $query = $GLOBALS['fluent']->update('administrators')->set($set)->where("username", $GLOBALS['User']->username)->execute();

     
        $user_ui = $user_data['user']."_new_app";
        
        $long = strtotime($Expira);
        
        $data_ui = json_encode(array(
                "userOld" => $user_ui, 
                "passwordOld" => $user_data['password'],
                "user" => $user_ui, 
                "pass" => $user_data['password'], 
                "date" => $long, 
                "connection" => 1
                ));
        
        $result_ui = CallAPI("POST", "http://panelapi.nextvapk.com/xtream_ui_connection.php?a=repairUserXtreamUI", $data_ui);

        $valuesHistory = array(
            'admin_id' => $GLOBALS['User']->id, 
            'admin_name' => $GLOBALS['User']->username, 
            'action' => 'Renovo Usuario', 
            'user_id' => $user->id, 
            'user_name' => $user->user, 
            'credits_old' => $oldCredits, 
            'credits_new' => $result ,
            'date' => $today,
            'old' => json_encode($set_user_old),
            'new' => json_encode($set_user)
        );

        $query = $GLOBALS['fluent']->insertInto('admin_history', $valuesHistory)->execute();

        return array(
            "code" => 0,
            "response" => "Succes"
        );
    }catch (PDOException $e) {
        return array(
            "code" => 2,
            "response" => "Error",
            "Message" => $e->getMessage()
        );
    } 
}

function GetUserDevices($data)
{
    $Content = $GLOBALS['fluent']
        ->from('devices')
        ->where("iduser", $data['id'])
        ->where("status", 1)
        ->fetchAll();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function GetUserDevicesStrikes($data)
{
    $Content = $GLOBALS['fluent']
        ->from('devices')
        ->select(null)
        ->select(array('id','strike', 'iduser','ip', 'macwifi', 'maceth', 'model', 'created_date', 
            '(SELECT user FROM users WHERE id = devices.iduser) AS userName', 
            '(SELECT content_block FROM users WHERE id = devices.iduser) AS content_block'))
        ->where("strike > ?", 0)
        ->fetchAll();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function DeleteDevice($data)
{
    try{
        $set = array('status' => 0);
        $query = $GLOBALS['fluent']->update('devices')->set($set)->where('id', $data['id'])->execute();
    
        $user = $GLOBALS['fluent']->from('users')
            ->where("id",$data['iduser'])
            ->fetch();
        $today = date('Y-m-d H:i:s');
    
        $valuesHistory = array(
            'admin_id' => $GLOBALS['User']->id, 
            'admin_name' => $GLOBALS['User']->username, 
            'action' => 'Borro Dispositivo Usuario', 
            'user_id' => $user->id, 
            'user_name' => $user->user, 
            'credits_old' => $GLOBALS['User']->credits, 
            'credits_new' => $GLOBALS['User']->credits ,
            'date' => $today,
            'old' => '',
            'new' => json_encode($data)
        );
    
        $queryInsert = $GLOBALS['fluent']->insertInto('admin_history', $valuesHistory)->execute();
    
        return array(
                "HH" => $valuesHistory,
                "code" => 0,
                "response" => "Succes"
            );
    }catch (PDOException $e) {
        return array(
            "code" => 2,
            "response" => "Error",
            "Message" => $e->getMessage()
        );
    }
}

function GetOnlineUsers()
{
    $fecha = date('Y-m-d H:i:s', strtotime('-20 minutes'));
    
    if($GLOBALS['User']->is_admin == 1 ){
        $usersOnline = $GLOBALS['fluent']
        ->from('user_online')
        ->where('date_update >= ?', $fecha)
        ->orderBy('date_update DESC')
        ->fetchAll();
    }else{
        $usersOnline = $GLOBALS['fluent']
        ->from('user_online')
        ->where('date_update >= ?', $fecha)
        ->where("dealer_id", $GLOBALS['User']->id)
        ->orderBy('date_update DESC')
        ->fetchAll();
    }
    

        return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $usersOnline,
            "Date" => $fecha
        );
}

function GetHistoryUsers($data)
{
     if($data["user"] == "all")
     {
        $usuariosHistory = $GLOBALS['fluent']
            ->from('user_history')
            ->orderBy('date DESC')
            ->limit(10000)
           ->fetchAll(); 
     }else
     {
         $usuariosHistory = $GLOBALS['fluent']
            ->from('user_history')
            ->orderBy('date DESC')
            ->where("user_name", $data["user"])
            ->limit(10000)
           ->fetchAll();
     }
         
     
            return array(
                "code" => 0,
                "response" => "Succes",
                "Content" => $usuariosHistory
            );
}

function CallAPI($method, $url, $data = false)
{
    $curl = curl_init();

    switch ($method)
    {
        case "POST":
            curl_setopt($curl, CURLOPT_POST, 1);

            if ($data){
                curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
                curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            }
            break;
        case "PUT":
            curl_setopt($curl, CURLOPT_PUT, 1);
            break;
        default:
            if ($data)
                $url = sprintf("%s?%s", $url, http_build_query($data));
    }

    // Optional Authentication:
    curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    curl_setopt($curl, CURLOPT_USERPWD, "username:password");

    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

    $result = curl_exec($curl);

    curl_close($curl);

    return $result;
}

#endregion

#region Cotent
function SearchContentImdb($id, $type)
{
    if($type != 2)
    {
        $url = 'https://api.themoviedb.org/3/movie/'.$id.'?api_key=26be60062e50b0d6e8e27f32b904b4ef&language=es';
        $content = file_get_contents($url);
        $json_es = json_decode($content, true);

        $url = 'https://api.themoviedb.org/3/movie/'.$id.'?api_key=26be60062e50b0d6e8e27f32b904b4ef';
        $content = file_get_contents($url);
        $json_en = json_decode($content, true);

        $url = 'https://api.themoviedb.org/3/movie/'.$id.'/videos?api_key=26be60062e50b0d6e8e27f32b904b4ef&language=en-US';
        $content = file_get_contents($url);
        $json_trailer = json_decode($content, true);

        $url = 'https://api.themoviedb.org/3/movie/'.$id.'/credits?api_key=26be60062e50b0d6e8e27f32b904b4ef';
        $content = file_get_contents($url);
        $json_reparto = json_decode($content, true);
    }
    else
    {
        $url = 'https://api.themoviedb.org/3/tv/'.$id.'?api_key=26be60062e50b0d6e8e27f32b904b4ef&language=es';
        $content = file_get_contents($url);
        $json_es = json_decode($content, true);

        $url = 'https://api.themoviedb.org/3/tv/'.$id.'?api_key=26be60062e50b0d6e8e27f32b904b4ef';
        $content = file_get_contents($url);
        $json_en = json_decode($content, true);

        $url = 'https://api.themoviedb.org/3/tv/'.$id.'/videos?api_key=26be60062e50b0d6e8e27f32b904b4ef&language=en-US';
        $content = file_get_contents($url);
        $json_trailer = json_decode($content, true);

        $url = 'https://api.themoviedb.org/3/tv/'.$id.'/credits?api_key=26be60062e50b0d6e8e27f32b904b4ef&language=en-US';
        $content = file_get_contents($url);
        $json_reparto = json_decode($content, true);
    }

    return array(
        "code" => 0,
        "response" => "Succes",
        "espanol" => $json_es,
        "ingles" => $json_en,
        "trailer" => $json_trailer,
        "reparto" => $json_reparto
    );
}

function SaveContent($data)
{
    try{
        $content = $data["Content"];
        $content_media = $data["ContentMedia"];
        
        $today = date("Y-m-d H:i:s");
        $salt = uniqid(mt_rand(), true);
        $media_id= md5($salt.$content["name_es"].$content["name_en"]);
    
        $content["media_id"] = $media_id;
        $content["created_date"] = $today;
        $content["updated_date"] = $today;
        $content["created_at"] = $GLOBALS['User']->username;
    
    
        $lk1 = strpos($content_media["link_original"], "cinemafullhdv6");
        $lk2 = strpos($content_media["link_original"], "cinemahd.appspot.com");
        $lk3 = strpos($content_media["link_original"], "full39.appspot.com");
        $lk4 = strpos($content_media["link_original"], "fullun39.appspot.com");
        $lk4 = strpos($content_media["link_original"], "staging.full39.appspot.com");
        $lk5 = strpos($content_media["link_original"], "movies-144816.appspot.com");
        $linkencode = "";
        $linknew = "";
        
        if($lk1 || $lk2 || $lk3 || $lk4){
            
            $vowels = array("https://storage.googleapis.com/", "http://storage.googleapis.com/", "staging.full39.appspot.com/");
            $id = str_replace($vowels, "", $content_media["link_original"]);
            $linkencode                 = encrypt($id, $GLOBALS['key']);
            
            $linkfinal           = str_replace("+", "%2B", $linkencode);
        
            $linknew                    = str_replace(" ", "%20", "https://medi39.com/media/gapi.php?id=".$linkfinal);
            $linkencode                 = encrypt($linknew, $GLOBALS['key']);
            
        }else if($lk5){
            $vowels = array("https://storage.googleapis.com/", "http://storage.googleapis.com/", "staging.full39.appspot.com/", "movies-144816.appspot.com/");
            $id = str_replace($vowels, "", $content_media["link_original"]);
            $linkencode                 = encrypt($id, $GLOBALS['key']);
            
            $linkfinal           = str_replace("+", "%2B", $linkencode);
        
    
            $linknew                    = str_replace(" ", "%20", "https://medi39.com/media/Media/gapi2.php?id=".$linkfinal);
            $linkencode                 = encrypt($linknew, $GLOBALS['key']);
        
        }else{
            $linknew                    = str_replace(" ", "%20", $content_media["link_original"]);
            $linkencode                 = encrypt($linknew, $GLOBALS['key']);        
        }
    
        $content_media["media_id"] = $media_id;
        $content_media["link_original"] = $linknew;
        $content_media["link_encode"] = $linkencode;
        $content_media["created_at"] = $GLOBALS['User']->username;
        $content_media["created_date"] = $today;
    
        $query = $GLOBALS['fluent']->insertInto('content', $content)->execute();
        $query = $GLOBALS['fluent']->insertInto('content_media', $content_media)->execute();
    
        return array(
            "code" => 0,
            "response" => "Succes",
            "content" => $content,
            "content_media" => $content_media
        );
    }catch (PDOException $e) {
        return array(
            "code" => 2,
            "response" => "Error",
            "Message" => $e->getMessage()
        );
    } 
}

function GetContent($data){

    $Content = $GLOBALS['fluent']
        ->from('content')
        ->where("media_id", $data['media_id'])
        ->fetch();

    return array(
        "code" => 0,
        "response" => "Succes",
        "Content" => $Content
    );
}

function EditContent($data){
    if(array_key_exists('Content', $data))
    {
        $content = $data["Content"];
    }
    else
    {
        $content = $data;
    }
        
    $today = date('Y-m-d H:i:s');
    $content["updated_date"] = $today;

    $query = $GLOBALS['fluent']->update('content')->set($content)->where('media_id', $content['media_id'])->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function GetContentList($type)
{
    if($type == 3)
    {
        $Content = $GLOBALS['fluent']
        ->from('content')
        ->select(null)
        ->select(array('id','media_id','idmdb','created_date','active','name_en', 'type'))
        ->where('(type = ? OR type = ?)', 4, 3)
        ->where("isdelete", 0)
        ->fetchAll();
    }else
    {
        $Content = $GLOBALS['fluent']
        ->from('content')
        ->select(null)
        ->select(array('id','media_id','idmdb','created_date','active','name_en', 'type'))
        ->where("type", $type)
        ->where("isdelete", 0)
        ->fetchAll();
    }
    

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function GetContentMediaList($data)
{
    $Content = $GLOBALS['fluent']
        ->from('content_media')
        ->where("media_id", $data['media_id'])
        ->fetchAll();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function EditContentMedia($data)
{
    
    $query = $GLOBALS['fluent']->update(' content_media')->set($data)->where('id', $data['id'])->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function SaveContentMedia($data)
{
    $content_media = $data["ContentMedia"];

    $lk1 = strpos($content_media["link_original"], "cinemafullhdv6");
    $lk2 = strpos($content_media["link_original"], "cinemahd.appspot.com");
    $lk3 = strpos($content_media["link_original"], "full39.appspot.com");
    $lk4 = strpos($content_media["link_original"], "fullun39.appspot.com");
    $lk4 = strpos($content_media["link_original"], "staging.full39.appspot.com");
    $lk5 = strpos($content_media["link_original"], "movies-144816.appspot.com");
    $linkencode = "";
    $linknew = "";
    
    if($lk1 || $lk2 || $lk3 || $lk4){
        
        $vowels = array("https://storage.googleapis.com/", "http://storage.googleapis.com/", "staging.full39.appspot.com/");
        $id = str_replace($vowels, "", $content_media["link_original"]);
        $linkencode                 = encrypt($id, $GLOBALS['key']);
        
        $linkfinal           = str_replace("+", "%2B", $linkencode);
    
        $linknew                    = str_replace(" ", "%20", "https://medi39.com/media/gapi.php?id=".$linkfinal);
        $linkencode                 = encrypt($linknew, $GLOBALS['key']);
        
    }else if($lk5){
        $vowels = array("https://storage.googleapis.com/", "http://storage.googleapis.com/", "staging.full39.appspot.com/", "movies-144816.appspot.com/");
        $id = str_replace($vowels, "", $content_media["link_original"]);
        $linkencode                 = encrypt($id, $GLOBALS['key']);
        
        $linkfinal           = str_replace("+", "%2B", $linkencode);
    

        $linknew                    = str_replace(" ", "%20", "https://medi39.com/media/Media/gapi2.php?id=".$linkfinal);
        $linkencode                 = encrypt($linknew, $GLOBALS['key']);
    
    }else{
        $linknew                    = str_replace(" ", "%20", $content_media["link_original"]);
        $linkencode                 = encrypt($linknew, $GLOBALS['key']);        
    }

    $content_media["link_original"] = $linknew;
    $content_media["link_encode"] = $linkencode;
    $content_media["created_at"] = $GLOBALS['User']->username;
    $content_media["created_date"] = $today;

    $query = $GLOBALS['fluent']->insertInto('content_media', $content_media)->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}
#endregion

#region ContentInfo
function Content(){

    $Generes = $GLOBALS['fluent']
        ->from('generes')
        ->orderBy('name_en ASC')
        ->fetchAll();

    $GeneresSpecial = $GLOBALS['fluent']
        ->from('generes_special')
        ->orderBy('name ASC')
        ->fetchAll();


    return array(
        "code" => 0,
        "response" => "Succes",
        "Generes" => $Generes,
        "GeneresSpecial" => $GeneresSpecial
    );
}

function SaveGenereContent($data)
{
    $today = date('Y-m-d H:i:s');
    $data['created_date'] = $today;
    $data['updated_date'] = $today;
    $query = $GLOBALS['fluent']->insertInto('generes', $data)->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function SaveGenereContentSpecial($data)
{
    $today = date('Y-m-d H:i:s');
    $data['created_date'] = $today;
    $data['updated_date'] = $today;
    $query = $GLOBALS['fluent']->insertInto('generes_special', $data)->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function EditGenereContent($data)
{
    $today = date('Y-m-d H:i:s');
    $data['updated_date'] = $today;
    $query = $GLOBALS['fluent']->update('generes')->set($data)->where('id',$data['id'])->execute();

    return array(
        "code" => 0,
        "response" => "Succes",
        "Data" => $data
    );
}

function EditGenereContentSpecial($data)
{
    $today = date('Y-m-d H:i:s');
    $data['updated_date'] = $today;
    $query = $GLOBALS['fluent']->update('generes_special')->set($data)->where('id',$data['id'])->execute();

    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

#endregion

#region Dash
function Dashboard(){
    $series = 0;
    $movies =0;
    $capitulos = 0;
    $canales = 0;
    $usersOnline = array();
    $usuariosHistory = array();
    $usuarios = array();
    $app_info = array();

    if($GLOBALS['User']->is_uploader){
        $movies = $GLOBALS['fluent']
            ->from('content')
            ->select(null)
            ->select('COUNT(*)')
            ->where("type", 1)
            ->fetch('COUNT(*)');

        $series = $GLOBALS['fluent']
            ->from('content')
            ->select(null)
            ->select('COUNT(*)')
            ->where("type", 2)
            ->fetch('COUNT(*)');

        $capitulos = $GLOBALS['fluent']
            ->from('content_media')
            ->select(null)
            ->select('COUNT(*)')
            ->where("season > ?", 0)
            ->fetch('COUNT(*)');

    }

    if($GLOBALS['User']->is_channel_uploader){
        $canales = $GLOBALS['fluent']
            ->from('canales')
            ->select(null)
            ->select('COUNT(*)')
            ->fetch('COUNT(*)');
    }

    if($GLOBALS['User']->is_dealer){
        $fecha = date('Y-m-d H:i:s', strtotime('-20 minutes'));
        
        
        if($GLOBALS['User']->is_admin == 1 ){
             
             $usersOnline = $GLOBALS['fluent']
                ->from('user_online')
                ->where('date >= ?', $fecha)
                ->orderBy('date DESC')
                ->limit(8)
                ->fetchAll();
                
            $usersOnlineCount = $GLOBALS['fluent']
                ->from('user_online')
                ->select(null)
                ->select('COUNT(*)')
                ->where('date >= ?', $fecha)
                ->orderBy('date DESC')
                ->fetch('COUNT(*)');
        
            $usuariosHistory = $GLOBALS['fluent']
                ->from('user_history')
                ->orderBy('date DESC')
                ->limit(5)
                ->fetchAll();
        }else{
             $usersOnline = $GLOBALS['fluent']
                ->from('user_online')
                ->where('date_update >= ?', $fecha)
                ->where("dealer_id", $GLOBALS['User']->id)
                ->orderBy('date_update DESC')
                ->limit(8)
                ->fetchAll();
                
            $usersOnlineCount = $GLOBALS['fluent']
                ->from('user_online')
                ->select(null)
                ->select('COUNT(*)')
                ->where('date_update >= ?', $fecha)
                ->where("dealer_id", $GLOBALS['User']->id)
                ->orderBy('date_update DESC')
                ->fetch('COUNT(*)');
        
            $usuariosHistory = $GLOBALS['fluent']
                ->from('user_history')
                ->orderBy('date DESC')
                ->where("dealer_id", $GLOBALS['User']->id)
                ->limit(5)
                ->fetchAll();

        }
        
       

        $usuarios = $GLOBALS['fluent']
            ->from('users')
            ->select(null)
            ->select('COUNT(*)')
            ->fetch('COUNT(*)');
            
        $params = [':name' => $GLOBALS['User']->username];
        
        $reports_count = $GLOBALS['fluent']
            ->from('reports')
            ->select(null)
            ->select('COUNT(*)')
            ->fetch('COUNT(*)');
    }
    
    if($GLOBALS['User']->is_dash_update){
        
        $app_info = $GLOBALS['fluent']
            ->from('app_version')
            ->select(null)
            ->select('movie, serie, tv, documental, radio, musical, ppv, adult')
            ->where("name", $GLOBALS['User']->app_allowed)
            ->fetch();
    }
    
    $usersStikes = $GLOBALS['fluent']
                ->from('devices')
                ->select(null)
                ->select('COUNT(*)')
                ->where('strike > ?', 0)
                ->fetch('COUNT(*)');

    return array(
        "code" => 0,
        "response" => "Succes",
        "movies" => $movies,
        "series" => $series,
        "capitulos" => $capitulos,
        "canales" => $canales,
        "usuarios" => $usuarios,
        "reports_count" => $reports_count,
        "usuariosOnline" => $usersOnline,
        "usersOnlineCount" => $usersOnlineCount,
        "usuariosHistory" => $usuariosHistory,
        "CreditosAllowed" => $GLOBALS['User']->credits_allowed,
        "Creditos" => $GLOBALS['User']->credits,
        "UserStrikes" => $usersStikes,
        "fecha" => $fecha,
        "app_info" => $app_info
    );
}

function DashEnable($data)
{
    $query = $GLOBALS['fluent']->update('app_version')->set($data)->where("name", $GLOBALS['User']->app_allowed)->execute();
    
    return array(
        "code" => 0,
        "response" => $data
    );
}
#endregion

#region Backgrounds
function SaveBacground($data)
{
    $app_name= $GLOBALS['User']->app_allowed;
    $content = $data["Content"];
    $content["app_allowed"] = $app_name;

    $query = $GLOBALS['fluent']->insertInto('fondos', $content)->execute();

    return array(
        "code" => 0,
        "response" => "Succes",
        "content" => $content
    );
}

function DeleteBackground($data)
{
    $content = $data["Content"];
    $queryd = $GLOBALS['fluent']->deleteFrom('fondos')->where('id', $content["id"])->execute();
    return array(
        "code" => 0,
        "response" => "Succes"
    );
}

function GetBackgrounds($data)
{
    $Content = $GLOBALS['fluent']
                ->from('fondos')
                ->where("app_allowed", $GLOBALS['User']->app_allowed)
                ->orderBy('orden ASC')
                ->fetchAll();

    return array(
            "code" => 0,
            "response" => "Succes",
            "Content" => $Content
        );
}

function EditBackground($data)
{
     $content = $data["Content"];
     
    $query = $GLOBALS['fluent']->update('fondos')->set($content)->where('id',$content['id'])->execute();

    return array(
        "code" => 0,
        "response" => "Succes",
        "Data" => $data
    );
}

#endregion

#region user Settings
function Login($data)
{
    if (!empty($data["username"]) AND !empty($data["passcode"])) {

        $query = $GLOBALS['fluent']->from('administrators')
        ->where("username", $data["username"])
        ->where("passcode", $data["passcode"])
        ->where('status', 1)
        ->where('is_admin', 1)
        ->fetchAll();

        if (sizeof($query) > 0) {
            $datauser = json_decode(utf8_encode(json_encode($query[0])), true);
            $contenido        = array();
            $contenido['exp'] = time() + 43200;
            $contenido['iat'] = time();
            $contenido["data"] = $datauser;
            $jwt               = JWT::encode($contenido, "S@w7sJxI@", 'HS256');

            return array(
                "code" => 0,
                "response" => "Succes",
                "token" => $jwt,
                "user" => $datauser
            );

        }else{
            return array(
                "code" => 3,
                "response" => "Usuario Incorrecto"
            );
        }

    }else {
        return array(
            "code" => 4,
            "response" => "Datos insuficientes"
        );
    }
}

function isValidToken()
{
    $token   = str_replace("\"", "", $_GET['token']);
    $headers = $_SERVER["HTTP_AUTHORIZATION"];
    $key     = "S@w7sJxI@";

    try {
        $tokenArray = JWT::decode($token, $key, array(
            'HS256'
        ));
        $datauser   = json_decode(utf8_encode(json_encode($tokenArray)), true);
        
        $query2 = $GLOBALS['fluent']->from('administrators')->where("username", $datauser["data"]["username"])->where('status', 1)->fetchAll();

        if (sizeof($query2) > 0) {
            $GLOBALS['User'] = $query2[0];

            return true;
        } else {
            header('Content-Type: application/json');
            print_r(json_encode(array(
                "code" => 900,
                "response" => "Expire"
            )));
            return false;
        }
        
    }
    catch (\Firebase\JWT\ExpiredException $e) {
        header('Content-Type: application/json');
        print_r(json_encode(array(
            "code" => 900,
            "response" => "Expire"
        )));
        return false;
    }
    catch (\Firebase\JWT\SignatureInvalidException $e) {
        header('Content-Type: application/json');
        print_r(json_encode(array(
            "code" => 901,
            "response" => "Invalid2"
        )));
        return false;
    }
    catch (\Exception $e) {
        header('Content-Type: application/json');
        print_r(json_encode(array(
            "code" => 901,
            "response" => "Invalid3 ". $e,
            "token" => $token
        )));
        return false;
    }
}

function getAuthorizationHeader(){
        $headers = null;
        if (isset($_SERVER['Authorization'])) {
            $headers = trim($_SERVER["Authorization"]);
        }
        else if (isset($_SERVER['HTTP_AUTHORIZATION'])) { //Nginx or fast CGI
            $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
        } elseif (function_exists('apache_request_headers')) {
            $requestHeaders = apache_request_headers();
            // Server-side fix for bug in old Android versions (a nice side-effect of this fix means we don't care about capitalization for Authorization)
            $requestHeaders = array_combine(array_map('ucwords', array_keys($requestHeaders)), array_values($requestHeaders));
            //print_r($requestHeaders);
            if (isset($requestHeaders['Authorization'])) {
                $headers = trim($requestHeaders['Authorization']);
            }
        }
        return $headers;
    }

function encrypt($text, $key)
{
    $block = mcrypt_get_block_size('rijndael_128', 'ecb');
    $pad   = $block - (strlen($text) % $block);
    $text .= str_repeat(chr($pad), $pad);
    return base64_encode(mcrypt_encrypt(MCRYPT_RIJNDAEL_128, $key, $text, MCRYPT_MODE_ECB));
}

function decrypt($str, $key)
{
    $str   = base64_decode($str);
    $str   = mcrypt_decrypt(MCRYPT_RIJNDAEL_128, $key, $str, MCRYPT_MODE_ECB);
    $block = mcrypt_get_block_size('rijndael_128', 'ecb');
    $pad   = ord($str[($len = strlen($str)) - 1]);
    $len   = strlen($str);
    $pad   = ord($str[$len - 1]);
    return substr($str, 0, strlen($str) - $pad);
}

#endregion